﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR
{
    public partial class SurveyLink : EfrBasePage
    {
        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/Questionnaires/Surveys.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                string pageTitle = "My Tasks > Questionnaires/Forms";

                int surveyId;
                if (Request.QueryString["activityId"] != null)
                {
                    if (int.TryParse(Request.QueryString["activityId"], out surveyId))
                    {
                        string formVersion = "Unknown";
                        try
                        {
                            string userId = "";
                            int registryId = 0;

                            userId = HttpContext.Current.User.Identity.Name;
                            registryId = UserSession.CurrentRegistryId;

                            VIRP.CRS.BO.WKF_CASE_ACTIVITY wca = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(userId, registryId, surveyId);

                            VIRP.EFR.BO.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT questionnaire =
                                VIRP.EFR.BLL.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KITManager.GetItemByActivityId(userId, registryId, wca.WKF_CASE_ACTIVITY_ID);
                                                        
                            if (questionnaire == null)
                            {
                                formVersion = "New";
                            }
                            else if (questionnaire.FORM_2009_FLAG != null && questionnaire.FORM_2009_FLAG == true)
                            {
                                formVersion = "2009";
                            }
                            else if (questionnaire.FORM_2012_FLAG != null && questionnaire.FORM_2012_FLAG == true)
                            {
                                formVersion = "2012";
                            }

                            if (wca.STD_WKFACTIVITYSTS_ID == 1)
                                pageTitle += " > In Process > Workflow ID " + wca.WKF_CASE_ID;
                            else if (wca.STD_WKFACTIVITYSTS_ID == 2)
                                pageTitle += " > Completed > Workflow ID " + wca.WKF_CASE_ID;
                            else
                                pageTitle += " > New > Workflow ID " + wca.WKF_CASE_ID;

                            ((Label)Master.FindControl("EfrPageTitle")).Text = pageTitle;
                        }
                        catch (Exception exc)
                        {
                            ServiceInterfaceManager.LogError("Error processing new referral" + exc.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                        }

                        FormVersion.Text = "The current version of this form is: " + formVersion;
                    }

                    hl2009.NavigateUrl = "~/Custom/EFR/Questionnaires/Survey2009.aspx?activityId=" + surveyId;
                    hl2012.NavigateUrl = "~/Custom/EFR/Questionnaires/Survey2012.aspx?activityId=" + surveyId;
                }

                ViewState["referrer"] = Request.UrlReferrer;
            }
        }

        protected void BackSurveyLink_Click(object sender, EventArgs e)
        {
            Uri from = ViewState["referrer"] as Uri;
            if (from != null && navigationSources.Contains(from.LocalPath))
                Response.Redirect(from.PathAndQuery);
        }
    }
}